/*
	File:		MoreMemory.h

	Contains:	Memory utility routines.

	Written by:	Quinn

	Copyright:	Copyright  1999 by Apple Computer, Inc., all rights reserved.

				You may incorporate this Apple sample source code into your program(s) without
				restriction. This Apple sample source code has been provided "AS IS" and the
				responsibility for its operation is yours. You are not permitted to redistribute
				this Apple sample source code as "Apple sample source code" after having made
				changes. If you're going to re-distribute the source, we require that you make
				it clear in the source that the code was descended from Apple sample source
				code, but that you've made changes.

	Change History (most recent first):

         <1>      1/3/99    Quinn   First checked in.
*/

#pragma once

/////////////////////////////////////////////////////////////////
// MoreIsBetter Setup

#include "MoreSetup.h"

/////////////////////////////////////////////////////////////////
// Mac OS Interfaces

#ifdef __cplusplus
extern "C" {
#endif

extern pascal OSErr SafeHoldMemory(void *start, ByteCount length);
	// A safe version of the HoldMemory call, that does the right
	// thing regardless of whether the HoldMemory trap is actually
	// implemented.
	//
	// Note that if the system can't hold the memory because there's
	// not enough physical memory, this routine will return
	// notEnoughMemoryErr.

extern pascal OSErr SafeUnholdMemory(void *start, ByteCount length);
	// A safe version of the HoldMemory call, that does the right
	// thing regardless of whether the HoldMemory trap is actually
	// implemented.

#ifdef __cplusplus
}
#endif
